﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using BezelEditor.Foundation.Extentions;
using BezelEditor.Mvvm;
using Reactive.Bindings.Extensions;

namespace Nintendo.Authoring.AuthoringEditor.Core
{
    public class AgeRating : DisposableModelBase
    {
        #region SelectedTargetSalesRegions

        public ObservableCollection<SelectedTargetSalesRegion> SelectedTargetSalesRegions { get; } =
            new ObservableCollection<SelectedTargetSalesRegion>(
                Enum.GetValues(typeof(TargetSalesRegion))
                    .Cast<TargetSalesRegion>()
                    .Select(x => new SelectedTargetSalesRegion {Region = x}));

        #endregion

        #region ProvidedRatings

        private ObservableCollection<RatingData> _ProvidedRatings = new ObservableCollection<RatingData>();

        public ObservableCollection<RatingData> ProvidedRatings
        {
            get { return _ProvidedRatings; }
            set { SetProperty(ref _ProvidedRatings, value); }
        }

        #endregion

        public AgeRating()
        {
            SelectedTargetSalesRegions
                .ObserveElementProperty(x => x.IsUse)
                .Subscribe(x =>
                {
                    // 選択した全販売地域における選択可能なレーティング機関のリストを生成
                    ProvidedRatings = SelectedTargetSalesRegions
                        .Where(y => y.IsUse)
                        .SelectMany(r => Constants.PresetTargetSalesRegionRatingData[r.Region])
                        .Distinct(r => r.RatingOrganization)
                        .ToObservableCollection();
                }).AddTo(CompositeDisposable);
        }
    }
}
