﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;

namespace SystemAudioMonitor
{
    public static class ArrayExtension
    {
        public static T[] Populate<T>(this T[] a, T value)
        {
            Debug.Assert(a != null);

            for (int i = 0; i < a.Length; ++i)
            {
                a[i] = value;
            }

            return a;
        }

        public static T[] Populate<T>(this T[] a, Func<int, T> factory)
        {
            Debug.Assert(a != null);
            Debug.Assert(factory != null);

            for (int i = 0; i < a.Length; ++i)
            {
                a[i] = factory(i);
            }

            return a;
        }
    }
}
