﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Nintendo.Audio;
using System;

namespace SpatialAudioEvaluationTool
{
    public class WavePlayback : IDisposable, IWaveProcessor
    {
        private WaveformFormat _format;
        private static readonly int ChannelCount = 6;
        private AudioObjectType[] _types = new AudioObjectType[]
{
            AudioObjectType.FrontLeft,
            AudioObjectType.FrontRight,
            AudioObjectType.FrontCenter,
            AudioObjectType.LowFrequency,
            AudioObjectType.BackLeft,
            AudioObjectType.BackRight,
};
        private SpatialAudioOut _audioOut;

        public WavePlayback(WaveformFormat format)
        {
            _format = format;
            _audioOut = new SpatialAudioOut(AudioObjectType.Surround_5_1);
            _audioOut.Start();
        }

        public void AddSamples(byte[] buffer, int offset, int count)
        {
            var sampleCount = count / ChannelCount / (_format.BitDepth / 8);
            var pcm = new float[sampleCount];
            for (var ch = 0; ch < ChannelCount; ++ch)
            {
                for (var i = 0; i < sampleCount; ++i)
                {
                    pcm[i] = (float)BitConverter.ToInt16(buffer, (ChannelCount * i + ch) * sizeof(short)) / (1 << 15);
                }
                _audioOut.Append(_types[ch], pcm);
            }
        }

        public void Dispose()
        {
            _audioOut?.Stop();
            _audioOut?.Dispose();
            _audioOut = null;
        }

        public void OnCaptureStopped(Exception e)
        {
            Dispose();
        }
    }
}
