﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;

namespace Nintendo.AudioTool
{
    /// <summary>
    ///  キャプチャが終了した際に呼ばれるイベントハンドラの引数です。
    /// </summary>
    public class SystemAudioCaptureStoppedEventArgs : EventArgs
    {
        // <summary>
        ///  コンストラクタです。
        /// </summary>
        public SystemAudioCaptureStoppedEventArgs(Exception exception = null)
        {
            Exception = exception;
        }

        /// <summary>
        ///  終了時に発生した例外です。
        /// </summary>
        public Exception Exception { get; }
    }
}
