﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "AudioFile.h"

/*--------------------------------------------------------------------------*
    Function prototypes
 *--------------------------------------------------------------------------*/
int getSoundInfo        (char *path, SOUNDINFO *info);
int getSoundSamples     (char *path, SOUNDINFO *info, void *dest);

int writeWaveFile       (char *path, SOUNDINFO *info, void *samples);
int writeAiffFile       (char *path, SOUNDINFO *info, void *samples);

typedef int (*soundFileFnType1)(u8 *path, SOUNDINFO *soundinfo);
typedef int (*soundFileFnType2)(u8 *path, SOUNDINFO *soundinfo, void *dest);
typedef int (*soundFileFnType3)(char *path, SOUNDINFO *info, void *samples);
