﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "AudioFile.h"

#define MAKE_A_DLL

#ifdef MAKE_A_DLL
#define LINKDLL __declspec(dllexport)
#else
#define LINKDLL __declspec(dllimport)
#endif

/*--------------------------------------------------------------------------*
    Function prototypes
 *--------------------------------------------------------------------------*/
LINKDLL int getSoundInfo        (char *path, SOUNDINFO *info);
LINKDLL int getSoundSamples     (char *path, SOUNDINFO *info, void *dest);

LINKDLL int writeWaveFile       (char *path, SOUNDINFO *info, void *samples);
LINKDLL int writeAiffFile       (char *path, SOUNDINFO *info, void *samples);
