﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "AdpcmCore.h"

/*---------------------------------------------------------------------------*
    exported functions pointers
 *---------------------------------------------------------------------------*/
u32 getBytesForAdpcmBuffer      (u32 samples);
u32 getBytesForAdpcmSamples     (u32 samples);
u32 getBytesForPcmBuffer        (u32 samples);
u32 getBytesForPcmSamples       (u32 samples);
u32 getNibbleAddress            (u32 samples);
u32 getNibblesForNSamples       (u32 samples);
u32 getSampleForAdpcmNibble     (u32 nibble);
u32 getBytesForAdpcmInfo        (void);

void encode
(
    s16         *src,   // location of source samples (16bit PCM signed little endian)
    u8          *dst,   // location of destination buffer
    ADPCMINFO   *cxt,   // location of adpcm info
    u32         samples // number of samples to encode
);

void decode
(
    u8          *src,   // location of encoded source samples
    s16         *dst,   // location of destination buffer (16 bits / sample)
    ADPCMINFO   *cxt,   // location of adpcm info
    u32         samples // number of samples to decode
);

void getLoopContext
(
    u8          *src,      // location of ADPCM buffer in RAM
    ADPCMINFO   *cxt,      // location of adpcminfo
    u32         samples    // samples to desired context
);


typedef u32 (*dspToolFnType1)(u32);
typedef u32 (*dspToolFnType2)(void);
typedef void (*dspToolFnType3)(s16*, u8*, ADPCMINFO*, u32);
typedef void (*dspToolFnType4)(u8*, s16*, ADPCMINFO*, u32);
typedef void (*dspToolFnType5)(u8*, ADPCMINFO*, u32);
