﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <nn/nn_Macro.h>

#include "SettingsManager_RapidJson.h"

//!< お知らせ設定の設定名か否かを表す値を返します。
bool IsSettingNameNewsSettings(const ::std::string& value) NN_NOEXCEPT;

//!< お知らせ設定をエクスポートします。
bool ExportNewsSettings(Node* pNode) NN_NOEXCEPT;

//!< お知らせ設定をインポートします。
bool ImportNewsSettings(const Node& node) NN_NOEXCEPT;

//!< 通知設定の設定名か否かを表す値を返します。
bool IsSettingNameNotificationSettings(const ::std::string& value) NN_NOEXCEPT;

//!< 通知設定をエクスポートします。
bool ExportNotificationSettings(Node* pNode) NN_NOEXCEPT;

//!< 通知設定をインポートします。
bool ImportNotificationSettings(const Node& node) NN_NOEXCEPT;

//!< アカウント毎の通知設定の設定名か否かを表す値を返します。
bool IsSettingNameAccountNotificationSettings(
    const ::std::string& value) NN_NOEXCEPT;

//!< アカウント毎の通知設定をエクスポートします。
bool ExportAccountNotificationSettings(Node* pNode) NN_NOEXCEPT;

//!< アカウント毎の通知設定をインポートします。
bool ImportAccountNotificationSettings(const Node& node) NN_NOEXCEPT;
