﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <nn/nn_Macro.h>

//!< ネームスコープを扱うクラスです。
class NameScope final
{
    NN_DISALLOW_COPY(NameScope);
    NN_DISALLOW_MOVE(NameScope);

private:
    //!< 名前を持つか否かを表す値
    bool m_HasName;

public:
    NameScope() NN_NOEXCEPT;

    explicit NameScope(const ::std::string& name) NN_NOEXCEPT;

    ~NameScope() NN_NOEXCEPT;

    //!< ネームスコープを返します。
    ::std::string Get() const NN_NOEXCEPT;
};
