﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <string>
#include <vector>
#include <nn/nn_Macro.h>

#include "SettingsManager_NameScope.h"
#include "SettingsManager_Utility.h"

namespace {

//!< ネームスコープを表すベクトルを返します。
::std::vector<::std::string>& GetNameScope() NN_NOEXCEPT
{
    NN_FUNCTION_LOCAL_STATIC(::std::vector<::std::string>, s_NameScope);

    return s_NameScope;
}

} // namespace

NameScope::NameScope() NN_NOEXCEPT
    : m_HasName(false)
{
    // 何もしない
}

NameScope::NameScope(const ::std::string& name) NN_NOEXCEPT
    : m_HasName(true)
{
    GetNameScope().push_back(name);
}

NameScope::~NameScope() NN_NOEXCEPT
{
    if (m_HasName)
    {
        GetNameScope().pop_back();
    }
}

::std::string NameScope::Get() const NN_NOEXCEPT
{
    return Join(".", GetNameScope().begin(), GetNameScope().end());
}
