﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <vector>
#include <nn/nn_Common.h>
#include <nn/settings/fwdbg/settings_SettingsManagement.h>

#include "SettingsManager_RapidJson.h"

//!< ファームウェアデバッグ設定をエクスポートします。
bool ExportFirmwareDebugSettings(Node* pNode) NN_NOEXCEPT;

//!< ファームウェアデバッグ設定をエクスポートします。
bool ExportFirmwareDebugSettings(
    Node* pNode, const ::std::vector<::std::string>& names) NN_NOEXCEPT;

//!< ファームウェアデバッグ設定をインポートします。
bool ImportFirmwareDebugSettings(
    const ::std::string& name, const Node& node) NN_NOEXCEPT;

//!< ファームウェアデバッグ設定をフラッシュします。
bool FlushFirmwareDebugSettings() NN_NOEXCEPT;

//!< ファームウェアデバッグ設定をダンプします。
bool DumpFirmwareDebugSettings(
    ::nn::Bit8 outBuffer[], size_t count,
    ::nn::settings::fwdbg::SettingsTarget target,
    const ::std::vector<::std::string>& names) NN_NOEXCEPT;
