﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <string>
#include <vector>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>

#include "SettingsManager_RapidJson.h"

//!< 設定のセクションのバイトサイズです。
const size_t SettingsSectionSize = 512 << 10;

//!< 設定をエクスポートします。
bool ExportSettings(Node* pNode) NN_NOEXCEPT;

//!< 設定をインポートします。
bool ImportSettings(const Node& node) NN_NOEXCEPT;

//!< 設定をリセットします。
bool ResetSettings(const ::std::string& mode) NN_NOEXCEPT;

//!< 設定をダンプします。
bool DumpSettings(
    ::std::unique_ptr<::std::vector<int64_t>>* pOutValue) NN_NOEXCEPT;

//!< 設定をロードします。
bool LoadSettings(::std::vector<int64_t>* buffer) NN_NOEXCEPT;
