﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace errors {

enum ErrorReportBinaryHeaderFlag : nn::Bit8
{
    ErrorReportBinaryHeaderFlag_AesEncrypted = 1 << 0,
    ErrorReportBinaryHeaderFlag_RsaEncrypted = 1 << 1,
    ErrorReportBinaryHeaderFlag_All = ErrorReportBinaryHeaderFlag_AesEncrypted | ErrorReportBinaryHeaderFlag_RsaEncrypted,
};

struct ToolVersion
{
    nn::Bit8 major;
    nn::Bit8 minor;
    nn::Bit8 micro;
    nn::Bit8 majorRelStep;
    nn::Bit8 minorRelStep;
};
ToolVersion GetToolVersion();
int GetToolVersionString(char* outStr, size_t outStrLength, const ToolVersion& toolVersion);

nn::Result ExportReport(const char* pathString, const nn::erpt::ReportList& reportList, ErrorReportBinaryHeaderFlag flags);

#if defined(NN_TOOL_DEVMENUCOMMANDSYSTEM)
nn::Result DecryptReport(bool* outValue, const char* inputFilePath, const char* outFilePath);
nn::Result DecryptAndDumpReport(bool* outValue, const char* inputFilePath);
#endif

}
