# 値の取得・設定コマンドの作成方法

## コマンド生成器作成

以下の関数を使用すると、対応する型を取得・設定するコマンドを生成する生成器を得られる。

- BoolCommand
- IntCommand
- StringCommand

これらの関数は

- name: 値の名前
- args(variadic arguments): 0 個以上の属性

をとる。

値の名前 \<name> に対し、

- get-\<name>
- set-\<name> \<value>

というコマンド生成され、それぞれ取得と設定を行うコマンドとなる。
実際の動作は属性値によってカスタマイズできる。

例えば、`StringCommand("my-value", ...)` は、

- 文字列の取得するコマンド get-my-value
- 文字列を設定するコマンド set-my-value

を生成する。

### BoolCommand

BoolCommand で生成されたコマンドは真偽値を扱う。
設定関数では以下の文字列によって真偽値を指定できる。

- true
    - "true"
    - "TRUE"
    - "True"
    - "T"
    - "enabled"
    - "enable"
- false
    - "false"
    - "FALSE"
    - "False"
    - "F"
    - "disabled"
    - "disable"

また、互換性維持を目的として、値の名前が "\<prefix>-enabled" の形である場合、

- enable-\<prefix>
- disable-\<prefix>

というコマンドも生成される。それぞれ、set-\<name> に true/false を渡したものとなる。
例えば、`Bool("my-value-enabled", ...)` であれば、

- get-my-value-enabled
- set-my-value-enabled \<true|false>
- enable-my-value
- disable-my-value

の 4 つのコマンドが生成される。
なお、これらの enable/disable コマンドは互換性維持目的で存在するため、ヘルプには表示されない。

### IntCommand

IntCommand で生成されたコマンドは int 値を扱う。
設定関数では数値を表す文字列を指定することができ、
[std::strtol()][std_strtol] で処理できる文字列の仕様に従って、8/10/16 進数を指定することができる。

また末尾に以下の文字列を付加した場合、対応する値だけ積算される。

- K = 1000
- M = 1000000
- G = 1000000000
- Ki = 1024
- Mi = 1024 * 1024
- Gi = 1024 * 1024 * 1024

例えば、"100Mi" と指定した場合、104857600 を指定したことになる。

[std_strtol]:http://en.cppreference.com/w/cpp/string/byte/strtol

### StringCommand

StringCommand で生成されたコマンドは文字列値を扱う。内部実装ではすべて std::string を使用している。
設定された値がそのまま使用される。

# 属性

属性には主に以下のようなものがある。

- Visibility
- Deprecated
- StringConverter
- Validator
- ArgumentString
- DataAccessor
- ReflectionTime

これらの属性は、生成器作成関数の引数に任意の順番で渡すことができる。

## Visibility

Visibility 属性は、コマンドを公開するかどうかや、コマンドのヘルプを表示するかどうかを制御する属性である。
以下のいずれかを指定できる。

- Public: 公開コマンドであり、ヘルプに表示される
- Hidden: 公開コマンドだが、ヘルプには表示されない
- Private: 内部用コマンドであり、内部用ツールではヘルプに表示される
- HiddenPrivate: 内部用コマンドであり、内部用ツールでもヘルプに表示されない

指定しなかった場合、暗黙的に Public が指定したものとみなされる。

## Deprecated

Deprecated 属性は、非推奨であることを指定する。
この属性が指定されている場合、Visibility 属性に無関係に、ヘルプに表示されない。

## StringConverter

StringConverter 属性は、コマンドライン上での設定や表示に使用される文字列と、内部表現型の値との相互変換の仕方を指定する属性である。
通常、コマンド生成器作成関数を使用した場合、適切なデフォルトの StringConverter が設定されているため、気にかける必要はない。

## Validator

Validator 属性は、入力値の制約をチェックする属性である。
設定コマンドで制約を満たさない値が指定された場合にはエラーとなる。
複数指定した場合には、一つでも Vaildator の制約を満たさなければエラーとなる。

### Min(n)/Max(n)

Min(n)/Max(n) 属性は、整数値の最小値・最大値を指定する。
`IntCommand("my-value", Max(100), ...)` で生成されたコマンドに対し `set-my-value 1000` のように指定するとエラーとなる。

### Align(n)

Align(n) 属性は、整数値のアラインメント制約を指定する。
`IntCommand("my-value", Align(1024), ...)` で生成されたコマンドに対し `set-my-value 1000` のように指定するとエラーとなる。

### OneOf({value1, value2, ...})

OneOf(...) 属性は、引数に与えられた値のいずれか一つであることを強制することを指定する。
`StringCommand("my-value", OneOf({"foo", "bar"}), ...)` で生成されたコマンドに対し、
`set-my-value foo` はエラーなく処理されるが、`set-my-value hoge` のように指定するとエラーとなる。

### Hex16

Hex16 属性は、文字列値が "0" または "0x0123456789abcdef" のフォーマットを持つべきことを指定する。
64bit の ID などに指定する。

## ArgumentString(s)

ArgumentString(s) 属性は、設定関数のヘルプに表示される引数部分の文字列を指定する。
`IntCommand("my-value", ArgumentString("<time_in_millisecond>"),...)` で生成されたコマンドに対しヘルプを表示すると、
`set-my-value <time_in_millisecond>` となる。

## DataAccessor

DataAccessor 属性は、値の取得・設定を実際に行う方法を指定する属性である。

### Fwdbg(keyName)

Fwdbg(keyName) は、keyName で指定される Firmware Debug Settings を使用して値の取得・設定をすることを指定する属性である。
keyName は、カテゴリ名とキー名を '/'(スラッシュ)でつなげた文字列を指定する。
`BoolCommand("my-value", Fwdbg("my_category/my_key_name"), ...)` で生成されたコマンドは、
Firmware Debug Settings の my_category カテゴリの my_key_name に対して bool 型の取得・設定を行う。

## ReflectionTime

ReflectionTime 属性は、値の設定をしたのちに、その値が反映するタイミングを指定する属性である。
指定された反映タイミングによって、値の設定コマンド実行後に対応したメッセージを出力する。
以下のいずれかを指定できる。

- NeedsRelaunchApplication: アプリケーションの再起動が必要である旨のメッセージを出力する
- NeedsRebootSystem: システムの再起動が必要である旨のメッセージを出力する

いずれも指定されなかった場合には、即時に反映されるものとして扱われ、メッセージは表示されない。

# enum 値の設定

enum 値を設定する場合には、専用のコマンド生成器作成関数 EnumCommand\<E>() を使用する。
テンプレート引数 E には、内部表現型を指定する。
この関数は以下の引数を持つ。

- name: 値の名前
- map: 値の名前と値のペア
- args(variadic arguments): 0 個以上の属性

map 引数は `{{key1, value1}, {key2, value2}, ...}` のような形で指定する。
`enum class E { A, B, C };` に対し

```
EnumCommand<E>("my-value",
{
    {"A", E::A},
    {"B", E::B},
    {"C", E::C},
}, ...)
```

で生成されたコマンドに対し、`set-my-value A` を実行すると `E::A` が設定され、
`set-my-value D` はエラーとなる。
また、`E::C` が設定されているときに `get-my-value` を実行すると "C" が取得できる。

また、

```
EnumCommand<int>("my-value",
{
    {"One", 1},
    {"Two", 2},
    {"Three", 3},
}, ...)
```

のようにすると、`set-my-value One` では 1 が設定され、
3 が設定されているときに `get-my-value` を実行すると "Three" が取得できる。

# 例

## movie-recording-extra-memory-size

movie-recording-extra-memory-size は以下のような設定値である。

- Type: int
    - 2Mi アライン
    - 最大 1Gi
- Visibility: 隠しコマンド
- DataAccessor: Firmware Debug Settings "am.debug/continuous_recording_extra_memory_size" へのアクセス
- ReflectionTime: アプリケーションの再起動が必要

これらを組み立ててコードにすると、

```
IntCommand("movie-recording-extra-memory-size",
    Fwdbg("am.debug/continuous_recording_extra_memory_size"),
    NeedsRelaunchApplication, Hidden,
    Align(2 * 1024 * 1024), Max(1024 * 1024 * 1024)
),
````

となる。

## continuous-recording-extra-memory-target-application-id

continuous-recording-extra-memory-target-application-id は以下のような設定値である。

- Type: string
    - 64bit の ID の文字列表現
- Visibility: 内部用隠しコマンド
- DataAccessor: Firmware Debug Settings "am.debug/continuous_recording_extra_memory_target_application_id" へのアクセス
- ReflectionTime: アプリケーションの再起動が必要

これらを組み立ててコードにすると、

```
StringCommand("continuous-recording-extra-memory-target-application-id",
    Fwdbg("am.debug/continuous_recording_extra_memory_target_application_id"),
    NeedsRelaunchApplication, HiddenPrivate,
    Hex16
),
```

となる。

## memory-mode

memory-mode は以下のような設定値である。

- Type: Bit8
    - auto: 0x00
    - 4GB: 0x01
    - 6GB: 0x11
- Visibility: 公開コマンド
- DataAccessor: BootConfig へのアクセス
- ReflectionTime: システムの再起動が必要

これらを組み立ててコードにすると、

```
EnumCommand<Bit8>("memory-mode",
    {
        {"auto", 0x00},
        {"4GB", 0x01},
        {"6GB", 0x11},
    },
    BootConfig(nn::bconfig::GetMemoryMode, nn::bconfig::SetMemoryMode),
    NeedsRebootSystem
),
```

となる。
※ BootConfig は DataAccessor 属性だが、ここでは解説しない。
※ 実際の memory-mode は内部用では設定値が増えるが、ここでは省略した。


# 汎用コマンドの作成方法(試験運用)

汎用コマンド作成関数 `Command` を使用することで、任意の個数の、任意のオプションを指定し、任意の動作を行うコマンドを生成するコマンド生成器を得ることができる。
この関数は

- name: コマンド名
- parameters: パラメータ情報
- f: 処理関数
    - parameters に対応する引数を引数にとる
    - ProcessResult を返す
- args(variadic arguments): 0 個以上の属性

をとる。

例えば、

```
Command("sample-command",
    Params(
        String(CmdOpt("--string,-s")),
        Int(CmdArg(0), ArgumentString("<argument>"), Min(0), Max(10))
    ),
    ProcessSampleCommand,
    Hidden
),
```

であれば、

- コマンド名 "sample-command"
- パラメータ
    - --string または -s で指定される文字列
    - 0 番目の整数型引数
        - 0 以上 10 以下
        - ヘルプには "\<argument>" と表示される
- 処理関数 ProcessSampleCommand: (std::string, int) -> ProcessResult
- Hidden: 隠しコマンドとして指定

となる。
