﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/util/util_Optional.h>

class ProgramIdNameMap
{
public:
    ProgramIdNameMap();
    ~ProgramIdNameMap();

    nn::Result Initialize();

    bool HasName(nn::Bit64 id);

    const char* GetName(nn::Bit64 id);

    nn::util::optional<nn::Bit64> GetId(const char* name);

private:
    class Impl;
    std::unique_ptr<Impl> m_Impl;
};

