﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/ae.h>

#include "DevMenuCommand_Label.h"
#include "DevMenuCommand_PowerCommand.h"

using namespace nn;

namespace
{
#ifdef NN_BUILD_CONFIG_OS_HORIZON
    void RebootFunction(ae::SystemAppletParameters*) NN_NOEXCEPT
    {
        ae::StartRebootSequence();
    }

    void ShutdownFunction(ae::SystemAppletParameters*) NN_NOEXCEPT
    {
        ae::StartShutdownSequence();
    }
#endif

    Result Reboot(bool* outValue, const Option&) NN_NOEXCEPT
    {
#ifdef NN_BUILD_CONFIG_OS_HORIZON
        ae::InvokeSystemAppletMain(ae::AppletId_SystemAppletMenu, RebootFunction);
#endif

        *outValue = true;
        NN_RESULT_SUCCESS;
    }

    Result Shutdown(bool* outValue, const Option&) NN_NOEXCEPT
    {
#ifdef NN_BUILD_CONFIG_OS_HORIZON
        ae::InvokeSystemAppletMain(ae::AppletId_SystemAppletMenu, ShutdownFunction);
#endif

        *outValue = true;
        NN_RESULT_SUCCESS;
    }

    const char HelpMessage[] =
        "usage: " DEVMENUCOMMAND_NAME " power reboot\n"
        "usage: " DEVMENUCOMMAND_NAME " power shutdown\n"
        ;

    struct SubCommand
    {
        std::string name;
        Result(*function)(bool* outValue, const Option&);
    };

    const SubCommand g_SubCommands[] =
    {
        { "reboot", Reboot},
        { "shutdown", Shutdown},
    };
}

Result PowerCommand(bool* outValue, const Option& option) NN_NOEXCEPT
{
    if (!option.HasSubCommand())
    {
        NN_LOG(HelpMessage);
        *outValue = false;
        NN_RESULT_SUCCESS;
    }
    else if (std::string(option.GetSubCommand()) == "--help")
    {
        NN_LOG(HelpMessage);
        *outValue = true;
        NN_RESULT_SUCCESS;
    }

    for (const SubCommand& subCommand : g_SubCommands)
    {
        if (subCommand.name == option.GetSubCommand())
        {
            return subCommand.function(outValue, option);
        }
    }

    NN_LOG("'%s' is not a DevMenu power command. See '" DEVMENUCOMMAND_NAME " power --help'.\n", option.GetSubCommand());
    *outValue = false;
    NN_RESULT_SUCCESS;
}
