﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <new>
#include <cctype>
#include <type_traits>

#include <nn/nn_Macro.h>
#include <nn/diag/text/diag_SdkTextOs.h>
#include <nn/nn_SdkLog.h>
#include <nn/util/util_BitUtil.h>

//-----------------------------------------------------------------------------
//  ここにある MakeArgv() および関連コードは、
//  Chris/Sources/Libraries/os/detail/os_Initialize-os.horizon.cpp にある
//  同名関数をコピー＆ペーストしてきたものである。
//-----------------------------------------------------------------------------

namespace {

    const char* SkipSpace(const char* p, const char* pEnd) NN_NOEXCEPT
    {
        for( ; (p < pEnd) && std::isspace(*p); p++ ) {}
        return p;
    }
    const char* GetTokenEnd(const char* p, const char* pEnd) NN_NOEXCEPT
    {
        for( ; (p < pEnd) && !std::isspace(*p); p++ ) {}
        return p;
    }
    const char* GetQuotedTokenEnd(const char* p, const char* pEnd) NN_NOEXCEPT
    {
        for( ; (p < pEnd) && (*p != '"'); p++ ) {}
        return p;
    }

}   // namespace

int MakeArgv(char** pArgvBuffer, char* pArgumentBuffer,
        const char* pCommandLine, size_t commandLineSize, int argumentCountMax) NN_NOEXCEPT
{
    int argumentIndex = 0;
    auto pSrc = pCommandLine;
    auto pDst = pArgumentBuffer;
    auto pSrcEnd = pSrc + commandLineSize;

    for(;;)
    {
        pSrc = SkipSpace(pSrc, pSrcEnd);

        if( pSrc >= pSrcEnd )
        {
            break;
        }

        if( argumentIndex >= argumentCountMax )
        {
            NN_SDK_LOG(NN_TEXT_OS("引数解析に失敗しました"));
            break;
        }

        const char* pSrcArgumentEnd;
        const char* pSrcNext;

        if( *pSrc == '"' )
        {
            pSrc++;
            pSrcArgumentEnd = GetQuotedTokenEnd(pSrc, pSrcEnd);
            pSrcNext = pSrcArgumentEnd + 1;
        }
        else
        {
            pSrcArgumentEnd = GetTokenEnd(pSrc, pSrcEnd);
            pSrcNext = pSrcArgumentEnd;
        }

        auto argumentSize = pSrcArgumentEnd - pSrc;

        pArgvBuffer[argumentIndex] = pDst;
        std::memcpy(pDst, pSrc, argumentSize);
        pDst += argumentSize;
        *pDst++ = '\0';

        pSrc = pSrcNext;
        argumentIndex++;
    }

    *pDst++ = '\0';

    // argv を NULL 終端する
    pArgvBuffer[argumentIndex] = NULL;

    return argumentIndex;
}

