﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/settings/settings_Language.h>

namespace devmenuUtil { namespace language {
    nn::settings::Language ConvertStringToLanguage(const char* languageString) NN_NOEXCEPT;

    const char* ConvertLanguageToString(nn::settings::Language language) NN_NOEXCEPT;

    nn::settings::Language ConvertLanguageCodeToLanguage(const nn::settings::LanguageCode& code) NN_NOEXCEPT;

    const char* ConvertLanguageCodeToString(const nn::settings::LanguageCode& code) NN_NOEXCEPT;
}} // devmenuUtil::language
