﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <nn/nn_Abort.h>

#include "DevMenuCommand_Language.h"

namespace devmenuUtil { namespace language {
namespace {
    const char* LanguageList[] = {
        "Japanese",
        "AmericanEnglish",
        "French",
        "German",
        "Italian",
        "Spanish",
        "Chinese",
        "Korean",
        "Dutch",
        "Portuguese",
        "Russian",
        "Taiwanese",
        "BritishEnglish",
        "CanadianFrench",
        "LatinAmericanSpanish",
        "SimplifiedChinese",
        "TraditionalChinese",
    };
}

    nn::settings::Language ConvertStringToLanguage(const char* languageString) NN_NOEXCEPT
    {
        for (int i = 0; i < NN_ARRAY_SIZE(LanguageList); i++)
        {
            if (std::strcmp(LanguageList[i], languageString) == 0)
            {
                return static_cast<nn::settings::Language>(i);
            }
        }
        NN_ABORT("'%s' is not supported language.\n", languageString);
    }

    const char* ConvertLanguageToString(nn::settings::Language language) NN_NOEXCEPT
    {
        int index = static_cast<int>(language);
        return LanguageList[index];
    }

    nn::settings::Language ConvertLanguageCodeToLanguage(const nn::settings::LanguageCode& code) NN_NOEXCEPT
    {
        for (int i = 0; i < NN_ARRAY_SIZE(LanguageList); i++)
        {
            auto language = static_cast<nn::settings::Language>(i);
            if (nn::settings::LanguageCode::Make(language) == code)
            {
                return static_cast<nn::settings::Language>(i);
            }
        }

        NN_ABORT("'%s' is not supported LanguageCode.\n", code.string);
    }

    const char* ConvertLanguageCodeToString(const nn::settings::LanguageCode& code) NN_NOEXCEPT
    {
        return ConvertLanguageToString(ConvertLanguageCodeToLanguage(code));
    }
}} // devmenuUtil::language
