﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/ncm/ncm_ContentMetaKey.h>
#include <nn/ncm/ncm_Service.h>
#include <nn/ncm/ncm_SubmissionPackageInstallTask.h>
#include "DevMenuCommand_Option.h"

namespace devmenuUtil
{

nn::Result PushApplicationRecordBasedOnDatabase(nn::ncm::ApplicationId id);
nn::Result ExistsHigherOrEqualVersion(bool* exists, nn::ncm::ApplicationId id, const nn::ncm::ContentMetaKey& key);
nn::Result Delete(const nn::ncm::ContentMetaKey& key, nn::ncm::StorageId storageId);
nn::Result DeleteBasedOnDatabase(nn::ncm::ContentMetaType type, nn::Bit64 id, nn::ncm::StorageId storageId);
nn::Result DeleteBasedOnDatabase(nn::ncm::ContentMetaType type, nn::ncm::ApplicationId id, nn::ncm::StorageId storageId);
nn::Result DeleteContent(const nn::ncm::StorageContentMetaKey* installedKey, int contentMetaKeyCount, nn::ncm::ApplicationId applicationId);
nn::Result InstallCommandCommon(nn::ncm::StorageContentMetaKey* outInstalledKey, int* outCount, int maxOutCount, bool* outValue, const Option& option, nn::ncm::ContentMetaType type);
nn::Result InstallCommonOne(bool* outValue, nn::ncm::StorageContentMetaKey* outInstalledKey, int* outCount, int maxOutCount, const char* nspPath, nn::ncm::StorageId storage, nn::ncm::ContentMetaType type, bool onlyPush, bool forceUpdate, bool skipInvalidateCache, int64_t detachMillisec);
nn::Result InstallCommonOne(bool* outValue, nn::ncm::StorageContentMetaKey* outInstalledKey, int* outCount, int maxOutCount, const char* nspPath, nn::ncm::StorageId storage, nn::ncm::ContentMetaType type, bool onlyPush, bool forceUpdate, bool skipInvalidateCache, int64_t detachMillisec, nn::ncm::SubmissionPackageInstallTask* task, bool ignoreTicket);
nn::Result InstallCommonOne(bool* outValue, nn::ncm::StorageContentMetaKey* outInstalledKey, int* outCount, nn::ncm::ApplicationId* outId, int maxOutCount, const char* nspPath, nn::ncm::StorageId storage, nn::ncm::ContentMetaType type, bool onlyPush, bool forceUpdate, bool skipInvalidateCache, int64_t detachMillisec);
nn::Result InstallCommonOne(bool* outValue, nn::ncm::StorageContentMetaKey* outInstalledKey, int* outCount, nn::ncm::ApplicationId* outId, int maxOutCount, const char* nspPath, nn::ncm::StorageId storage, nn::ncm::ContentMetaType type, bool onlyPush, bool forceUpdate, bool skipInvalidateCache, int64_t detachMillisec, nn::ncm::SubmissionPackageInstallTask* task, bool ignoreTicket);

nn::Result CheckHigherVersionAndUninstallIfNeeded(bool* exists, nn::ncm::ContentMetaDatabase* db, nn::ncm::ContentStorage* storage, const nn::ncm::ContentMetaKey& key, bool doUninstall);
nn::Result VerifyCombinationWithApplicationAtPatchInstall(bool* outValue, const nn::ncm::StorageContentMetaKey* installedKey, int contentMetaKeyCount, nn::ncm::ApplicationId applicationId);
}
