﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <string>
#include <nn/nn_Log.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/ns/ns_FactoryResetApi.h>

#include "DevMenuCommand_Label.h"
#include "DevMenuCommand_Option.h"
#include "DevMenuCommand_FactoryResetCommand.h"

using namespace nn;

namespace
{
    const char HelpMessage[] =
        "usage: " DEVMENUCOMMAND_NAME " factoryreset do\n"
        "       " DEVMENUCOMMAND_NAME " factoryreset do-without-usersavedata \n"
        ;


    struct SubCommand
    {
        std::string name;
        Result(*function)(bool* outValue, const Option&);
    };

    Result DoCommand(bool* outValue, const Option&)
    {
        ns::ResetToFactorySettings();

        *outValue = true;
        NN_RESULT_SUCCESS;
    }

    Result DoWithoutUserSaveDataCommand(bool* outValue, const Option&)
    {
        ns::ResetToFactorySettingsWithoutUserSaveData();

        *outValue = true;
        NN_RESULT_SUCCESS;
    }

    const SubCommand g_SubCommands[] =
    {
        { "do", DoCommand },
        { "do-without-usersavedata", DoWithoutUserSaveDataCommand }
    };
}

Result FactoryResetCommand(bool* outValue, const Option& option)
{
    if (!option.HasSubCommand())
    {
        NN_LOG(HelpMessage);
        *outValue = false;
        NN_RESULT_SUCCESS;
    }
    else if (std::string(option.GetSubCommand()) == "--help")
    {
        NN_LOG(HelpMessage);
        *outValue = true;
        NN_RESULT_SUCCESS;
    }

    for (const SubCommand& subCommand : g_SubCommands)
    {
        if (subCommand.name == option.GetSubCommand())
        {
            return subCommand.function(outValue, option);
        }
    }

    NN_LOG("'%s' is not a DevMenu factoryreset command. See '" DEVMENUCOMMAND_NAME " factoryreset --help'.\n", option.GetSubCommand());
    *outValue = false;
    NN_RESULT_SUCCESS;
}
