﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

/**
 * @brief   開発用バージョンで EULA を同意状態にします。
 * @pre
 *  - Time ライブラリが初期化済
 * @details
 *  バージョンを問わず、本体リージョンと一致する EULA が既に同意済であった場合は何も行いません。
 */
void AcceptEulaInDevVersion() NN_NOEXCEPT;

/**
 * @brief   開発用バージョンの EULA を非同意状態にします。
 * @details
 *   本体リージョンと一致する、開発用バージョンの EULA 同意情報のみを削除します。
 */
void RejectEulaOfDevVersion() NN_NOEXCEPT;
