﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>


param
(
    [parameter(mandatory=$true)][string]
    $VersionXmlPath,

    [parameter(mandatory=$true)][string]
    $CreateFilePath,

    [string]
    $FileType = 'FirmwareVersion'
)

# trap
# {
#     Write-Error "error occurred."
#     exit 1
# }

Set-StrictMode -Version 2.0


if(-Not(Test-Path $VersionXmlPath))
{
   throw "error: `$VersionXmlPath is not found. ($VersionXmlPath)"
}

$xml = [xml] (Get-Content $VersionXmlPath)

if($FileType -eq "FirmwareVersion")
{
    $Identifier = "FIRMWARE_VERSION"
    $major = $xml.Product.Version.Major
    $minor = $xml.Product.Version.Minor
    $micro = $xml.Product.Version.Micro
    $majorRelstep = $xml.Product.Version.MajorRelstep
    $minorRelstep = $xml.Product.Version.MinorRelstep

    $textContent = @"
#define NN_$($Identifier)_VERSION_MAJOR          $($major)
#define NN_$($Identifier)_VERSION_MINOR          $($minor)
#define NN_$($Identifier)_VERSION_MICRO          $($micro)
#define NN_$($Identifier)_VERSION_MAJORRELSTEP   $($majorRelstep)
#define NN_$($Identifier)_VERSION_MINORRELSTEP   $($minorRelstep)
"@
}
$textContent | Set-Content $CreateFilePath -Encoding UTF8
