﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/nn_SdkAssert.h>
#include "wlan_BaseFunctions.h"
#include "wlan_CommonType.h"
#include "wlan_StateMachine.h"
#include "wlan_DebugLog.h"

namespace nn { namespace wlan {

class StateMachine;

class WpaSupplicant
{
public:
    static const Bit16 EtherProtocolPae = 0x888E; /* Port Access Entity (IEEE 802.1X) */
public:
    WpaSupplicant() NN_NOEXCEPT;
    ~WpaSupplicant() NN_NOEXCEPT;

    bool InitializeSupplicant() NN_NOEXCEPT;
    void FinalizeSupplicant() NN_NOEXCEPT;
    bool ScanRequest(WlanScanParameters* pScanParams) NN_NOEXCEPT;
    bool CancelScan() NN_NOEXCEPT;
    void ForwardEvent(void* pEvent, void* pBuf) NN_NOEXCEPT;
    void ForwardRxEapol(void* pBuf) NN_NOEXCEPT;
    bool JoinNetwork(WlanConnectinoParameters *pConnectParams) NN_NOEXCEPT;
    bool CancelJoinNetwork() NN_NOEXCEPT;
    bool Disassociate() NN_NOEXCEPT;
    bool JoinNetworkWithWps(WlanWpsParameters *pConnectParams) NN_NOEXCEPT;
    bool SetGtkKeyInfo() NN_NOEXCEPT;
    bool ClearGtkKeyInfo() NN_NOEXCEPT;

    static int EventCallBackFromSupplicant(void *ctx, int level, int type, const char *buf, int len) NN_NOEXCEPT;
    static int TxEapolCallBackFromSupplicant(void *buf) NN_NOEXCEPT;
    static int IoctlCallBackFromSupplicant(void *ifh, int cmd, void *buf, int len, bool set) NN_NOEXCEPT;

    static void BindStateMachineInstance(StateMachine* pStateMachine) NN_NOEXCEPT
    {
        NN_SDK_ASSERT_NOT_NULL(pStateMachine);
        m_pStateMachine = pStateMachine;
    }

    void SetSleepFlag(bool var) NN_NOEXCEPT
    {
        m_IsSleepState = var;
    }
private:
    void RegisterCallbacks() NN_NOEXCEPT;
private:
    // needs to be static to be used in static callbacks
    static void*             m_WpaSuppHandle;
    static StateMachine*     m_pStateMachine;
    bool                     m_IsInitialized;
    static bool              m_IsSleepState;
};

}}

