﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "wlan_CommonType.h"
#include "wlan_DebugLog.h"

namespace nn { namespace wlan {

class VieManager
{
public:
    static const uint32_t VieLengthMax = 255;
    uint32_t m_totalLengh;
    uint32_t m_ieCount;   // IE保持数

    WlanIeContainer* m_pIeHead; // リストの先頭
    WlanIeContainer* m_pIeTail; // リストの最後

public:
    VieManager() NN_NOEXCEPT;
    ~VieManager() NN_NOEXCEPT;

    // TODO nn::Resultを返すようにする
    bool CreateIe(uint32_t* pOutIndex, WlanIeContainer* ie ) NN_NOEXCEPT;
    bool RemoveIe(uint32_t index) NN_NOEXCEPT;
    void GetWlanIeContainer(WlanIeContainer** pOut, uint32_t index) NN_NOEXCEPT;
private:
    void DumpList() NN_NOEXCEPT;
};

}}

