﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*! @file
    @brief    Stateの定義
*/

#pragma once

#include "wlan_WdrvStateDefinition.h"

namespace nn {
namespace wlan {

//#define ENABLE_DISPLAY_STATE
#if defined (ENABLE_DISPLAY_STATE)
#define DISPLAY_STATE(cls, func, line)   \
        (cls).DisplayWlanState(static_cast<const char*>((func)), (line))
#else /* ENABLE_DISPLAY_STATE */
#define DISPLAY_STATE(cls, func, line)
#endif /* ENABLE_DISPLAY_STATE */

//! ステートを表すクラス
class State
{
public:
    State() NN_NOEXCEPT {}

    State(WdrvMainState mainState, WdrvSubState subState) NN_NOEXCEPT
        : m_MainState(mainState),
          m_SubState(subState)
    {}

    ~State() NN_NOEXCEPT {}

    inline void SetMain(WdrvMainState state) NN_NOEXCEPT
    {
        m_MainState = state;
    }

    inline void SetSub(WdrvSubState state) NN_NOEXCEPT
    {
        m_SubState = state;
    }

    bool operator ==(const State& rhs) const NN_NOEXCEPT
    {
        return m_MainState == rhs.m_MainState && m_SubState == rhs.m_SubState;
    }

    bool operator !=(const State& rhs) const NN_NOEXCEPT
    {
        return m_MainState != rhs.m_MainState || m_SubState != rhs.m_SubState;
    }

    inline WdrvMainState GetMain() const NN_NOEXCEPT
    {
        return m_MainState;
    }

    inline WdrvSubState GetSub() const NN_NOEXCEPT
    {
        return m_SubState;
    }

#if defined (ENABLE_DISPLAY_STATE)
    void DisplayWlanState(const char *func, int line) NN_NOEXCEPT
    {
        NN_SDK_LOG("WDMS: State=[%s, %s] in %s -line %d\n",
               MainStateStr[m_MainState], SubStateStr[m_SubState], func, line);
    }
#endif /* ENABLE_DISPLAY_STATE */

private:
    WdrvMainState     m_MainState;
    WdrvSubState      m_SubState;
};

#undef ENABLE_DISPLAY_STATE

} // end of namespace wlan
} // end of namespace nn

