﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>

namespace nn { namespace wlan {

//!< ファームウェアデバッグ設定を扱うクラスです。
class FirmwareDebugSettings final
{
    NN_DISALLOW_COPY(FirmwareDebugSettings);
    NN_DISALLOW_MOVE(FirmwareDebugSettings);

private:
    FirmwareDebugSettings() NN_NOEXCEPT;

    ~FirmwareDebugSettings() NN_NOEXCEPT;

public:
    //!< ファームウェアデバッグ設定を明示的に初期化します。
    static void Initialize() NN_NOEXCEPT;

    //!< wlan プロセスのブートが制限されているか否かを返します
    static bool IsSkipBoot() NN_NOEXCEPT;
};

}} // namespace nn::wlan
