﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/* NX固有の機能、チップに関するものはこちらに記載 */

#include "wlan_CommonType.h"
#include <wlioctl.h>
#include <bwl.h>

namespace nn { namespace wlan {

#define WLANTYPE_DEBUG

#if defined (WLANTYPE_DEBUG)
/* デバッグ用のMagic wrord */
static const size_t WlanTypeMagic = 0x1621aa55;
#endif // WLANTYPE_DEBUG

#if 1
#else
enum WlanCmdEvnt {
    /*
     * Message Bufferを共しているので、Command/Eventは
     * 連番IDとして運用する
     */
    WLAN_COMMAND_START            = 0,
    WLAN_INITIALIZE,
    WLAN_FINALIZE,

    WLAN_CHANGE_STATE_INFRA       = 5,
    WLAN_CHANGE_STATE_LOCAL_AP,
    WLAN_CHANGE_STATE_LOCAL_STA,
    WLAN_CHANGE_STATE_LOCAL_SPECTATOR,

    WLAN_SET_IFUPDOWN             = 10,
    WLAN_GET_IFUPDOWN,
    WLAN_SET_EVENTMASK,
    WLAN_GET_EVENTMASK,

    WLAN_SCAN_REQUEST,
    WLAN_SCANLIST_REQUEST,
    WLAN_CANCEL_SCAN,
    WLAN_GET_MACADDRESS,

    WLAN_CREATE_AP                = 30,
    WLAN_JOIN_NETWORK_STA,
    WLAN_DISASSOCIATE,

    WLAN_COMMAND_LAST             = 255,

    WLAN_EVENT_START              = 256,
    WLAN_EVENT_SCAN_INDICATION,
    WLAN_EVENT_SCAN_COMPLETE,

    WLAN_EVENT_CONNECTED
};
#endif


/* 非同期系のコマンド終了を待つか? */
enum WlanCommandWait {
    WAIT_CMD_FINISH = 1,
    NOWAIT_FINISH
};


/*
    association status (succeeded/failed)
    deauthenticated
    disassociated
    beacons lost
    beacon received
    scan complete
    interface created/modified/destroyed
*/
enum WlanEventType
{
    ASSOCIATE_SUCCEEDED,
    ASSOCIATE_FAILED,
    DEAUTHENTICATED,
    DISASSOCIATED,
    BEACON_LOST,
    SCAN_COMPLETE,
    INTERFACE_CREATED,
    INTERFACE_MODIFIED,
    INTERFACE_DESTROYED,

    BEACON_RECEIVED,

    EVENT_TYPE_MAX
};

#define    PRN_BOOL(x)    (((x)==true)? "TRUE": "FALSE")

}}
