﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkLog.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/lmem/lmem_ExpHeap.h>

#include "wlan_HipcServer.h"

#include <type_traits>
#include <new>
#include <nn/nn_SdkAssert.h>

namespace nn { namespace wlan { namespace server {

HipcServerManager::HipcServerManager(nn::wlan::StateMachine* pStateMachine) NN_NOEXCEPT
        : m_InfraApiImpl(pStateMachine),
          m_LocalApiImpl(pStateMachine),
          m_LocalGetFrameApiImpl(pStateMachine),
          m_LocalGetActionFrameApiImpl(pStateMachine),
          m_SocketApiImpl(pStateMachine),
          m_SocketGetFrameApiImpl(pStateMachine),
          m_DetectApiImpl(pStateMachine),
          m_InfraService(&m_InfraApiImpl),
          m_LocalService(&m_LocalApiImpl),
          m_LocalGetFrameService(&m_LocalGetFrameApiImpl),
          m_LocalGetActionFrameService(&m_LocalGetActionFrameApiImpl),
          m_SocketService(&m_SocketApiImpl),
          m_SocketGetFrameService(&m_SocketGetFrameApiImpl),
          m_DetectService(&m_DetectApiImpl)
{

    RegisterObjectForPort(m_InfraService.GetShared(), 10, nn::wlan::detail::InfraServiceName);  // セッション数適当
    RegisterObjectForPort(m_LocalService.GetShared(), 10, nn::wlan::detail::LocalServiceName);  // セッション数適当
    RegisterObjectForPort(m_LocalGetFrameService.GetShared(), 10, nn::wlan::detail::LocalGetFrameServiceName);  // セッション数適当
    RegisterObjectForPort(m_LocalGetActionFrameService.GetShared(), 10, nn::wlan::detail::LocalGetActionFrameServiceName);  // セッション数適当
    RegisterObjectForPort(m_SocketService.GetShared(), 10, nn::wlan::detail::SocketServiceName);  // セッション数適当
    RegisterObjectForPort(m_SocketGetFrameService.GetShared(), 10, nn::wlan::detail::SocketGetFrameServiceName);  // セッション数適当
    RegisterObjectForPort(m_DetectService.GetShared(), 4, nn::wlan::detail::DetectServiceName);  // セッション数適当

    // サーバマネージャの開始
    // ただし、実際のサーバ動作は、LoopAuto 関数等を呼び出すことで行う必要がある
    Start();

}

HipcServerManager::~HipcServerManager() NN_NOEXCEPT
{
}

}}}

