﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_SdkAssert.h>
#include <nn/sf/sf_Types.h>

#include "../wlan_CommonType.h"
#include "../wlan_StateMachine.h"
#include "../wlan_DebugLog.h"
#include "../../../Libraries/wlan/detail/wlan_IWlanManagers.sfdl.h"

namespace nn { namespace wlan{ namespace server
{

class ApiImplBase
{
protected:
    // WLANプロセスで走るステートマシーンの実体を受け取るためのポインタ
    nn::wlan::StateMachine* m_pStateMachine;

public:
    // MACアドレスを取得する
    nn::Result GetMacAddress(nn::sf::Out<nn::wlan::detail::SfdlMacAddress> pOutMacAddr) NN_NOEXCEPT;
    // StateMachineのステートを上位層向けステート名に変更して返す
    nn::Result GetState(nn::sf::Out<uint32_t> pOutState) NN_NOEXCEPT;

protected:
    // 通信モードの変更を行う
    nn::Result ChangeMode(WlanCommandId id) NN_NOEXCEPT;
    // I/FのUpまたはDownを行う
    nn::Result RequestIfUpDown(uint32_t value) NN_NOEXCEPT;
    // 実行可能ステートのチェックを行う
    nn::Result CheckState(WdrvMainState* allowedStates, uint8_t length) NN_NOEXCEPT;
    // StateMachineのステートを取得する
    void GetWlanState(WlanStates* states) NN_NOEXCEPT;
};

}}} // end of namespace nn::wlan::server

