﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/mbuf/mbuf_Mbuf.h>
#include <bwl.h>
#include "../wlan_DebugLog.h"
#if defined(NN_BUILD_CONFIG_HARDWARE_NX)
#include <nn/settings/factory/settings_WirelessLan.h>
#endif

namespace nn { namespace wlan {

// ドライバの戻り値に対応する Result のアボートを発生させる
void AbortDriverResult(int32_t result);

#define WLAN_ABORT_UNLESS_DRIVER_RESULT_SUCCESS(result) do { \
    if (result != BCME_OK) \
    { \
        WLAN_LOG_FATAL("%s() @ %s(%d)\n", __FUNCTION__, __FILE__, __LINE__); \
        AbortDriverResult(result); \
    } \
    } while (0)

namespace driver {

/*
 * Action frameのデータ取り出しに関する情報
 */

// イベントバッファの実データが格納されている場所までのオフセット値
// bcm_event_tに依存
static const size_t offsetToData = sizeof(bcm_event_t);
static const size_t offsetToDataEx = offsetToData + sizeof(wl_event_rx_frame_data_t);

// ActionFrameイベントバッファのSubtypeが格納されている場所までのオフセット値
// bcm_event_tに依存
static const size_t offsetToActionFrameSubtype = offsetToData + 4; // Category(1) + OUI(3)の次にSubtypeが格納されている
static const size_t offsetToActionFrameSubtypeEx = offsetToDataEx + 4; // Category(1) + OUI(3)の次にSubtypeが格納されている

// ActionFrameイベントバッファの相手先MACアドレスを取得する
void GetPeerMacAddress(uint8_t* pOutBuf, void* pBuf) NN_NOEXCEPT;

// ActionFrameイベントバッファのデータサイズを取得する
size_t GetActionFrameDataSize(void* pBuf) NN_NOEXCEPT;
size_t GetActionFrameDataSizeEx(void* pBuf) NN_NOEXCEPT;

// maximum channels
static const uint32_t ChannelCountMax = WL_NUMCHANNELS;

#if defined(NN_BUILD_CONFIG_HARDWARE_NX)
static const uint8_t CountryCodeCounts = 6;
static const uint8_t DeviceCounts = 4;

struct CountryCodeInfo
{
    nn::settings::factory::CountryCode hwCountryCode;
    wl_country_t drvCountryCode;
};

static const CountryCodeInfo NxCountryCodes[CountryCodeCounts] = {
    {  // JP & EU for PROD
        {"R1"},
        {"JP", 971, "JP"},
    },
    {  // US & AU for PROD
        {"R2"},
        {"Q1", 936, "Q1"},
    },
    {  // JP & EU for PROD Mariko
        {"S1"},
        {"JP", 971, "JP"},
    },
    {  // US & AU for PROD Mariko
        {"S2"},
        {"Q1", 936, "Q1"},
    },
    {  // JP & EU for PROD H
        {"T1"},
        {"JP", 124, "JP"},
    },
    {  // US & AU for PROD H
        {"T2"},
        {"US", 861, "US"},
    }
};

static const CountryCodeInfo NxCountryCodesSdev[DeviceCounts] = {
    {
        // 1SKU for SDEV
        {"R0"},
        {"XV", 984, "XV"},
    },
    {
        // 1SKU for SDEV Mariko (Mariko SDEVの仮決めリージョンコード(SIGLO-79963))
        {"M0"},
        {"XV", 984, "XV"},
    },
    {
        // 1SKU for SDEV Mariko
        {"S0"},
        {"XV", 984, "XV"},
    },
    {
        // 1SKU for SDEV H
        {"T0"},
        {"XT", 96, "XT"},
    }
};

static const CountryCodeInfo NxCountryCodesEdev[DeviceCounts] = {
    {
        // 1SKU for EDEV
        {"R3"},  // (SIGLO-79963)
        {"XT", 981, "XT"},
    },
    {
        // 1SKU for EDEV Mariko (SIGLO-79963)
        {"M0"},
        {"XT", 981, "XT"},
    },
    {
        // 1SKU for EDEV Mariko
        {"S0"},
        {"XT", 981, "XT"},
    },
    {
        // 1SKU for EDEV H
        {"T0"},
        {"XT", 96, "XT"},
    }
};
#endif

}}}

