﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/wlan/wlan_Result.h>
#include "../wlan_Util.h"
#include "wlan_driver.Mezcal.h"

namespace nn { namespace wlan {

void AbortDriverResult(int32_t result)
{
    switch (result)
    {
    case BCME_OK:
        break;
    case BCME_ERROR:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultGenericError());
        break;
    case BCME_BADARG:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultBadArgument());
        break;
    case BCME_BADOPTION:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultBadOption());
        break;
    case BCME_NOTUP:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultNotIfUp());
        break;
    case BCME_NOTDOWN:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultNotIfDown());
        break;
    case BCME_NOTAP:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultNotAp());
        break;
    case BCME_NOTSTA:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultNotSta());
        break;
    case BCME_BADKEYIDX:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultBadKeyIdx());
        break;
    case BCME_RADIOOFF:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultRadioOff());
        break;
    case BCME_NOTBANDLOCKED:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultNotBandLocked());
        break;
    case BCME_NOCLK:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultNoClock());
        break;
    case BCME_BADRATESET:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultBadRateSet());
        break;
    case BCME_BADBAND:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultBadBand());
        break;
    case BCME_BUFTOOSHORT:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultDrvBufferTooShort());
        break;
    case BCME_BUFTOOLONG:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultDrvBufferTooLong());
        break;
    case BCME_BUSY:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultBusy());
        break;
    case BCME_NOTASSOCIATED:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultNotAssociated());
        break;
    case BCME_BADSSIDLEN:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultBadSsidLen());
        break;
    case BCME_OUTOFRANGECHAN:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultOutOfRangeChannel());
        break;
    case BCME_BADCHAN:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultBadChannel());
        break;
    case BCME_BADADDR:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultBadAddress());
        break;
    case BCME_NORESOURCE:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultNoResource());
        break;
    case BCME_UNSUPPORTED:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultUnSupported());
        break;
    case BCME_BADLEN:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultBadLen());
        break;
    case BCME_NOTREADY:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultNotReady());
        break;
    case BCME_EPERM:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultNotPermitted());
        break;
    case BCME_NOMEM:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultNoMemory());
        break;
    case BCME_ASSOCIATED:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultAssociated());
        break;
    case BCME_RANGE:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultNotInRange());
        break;
    case BCME_NOTFOUND:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultNotFound());
        break;
    case BCME_WME_NOT_ENABLED:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultWmeNotEnabled());
        break;
    case BCME_TSPEC_NOTFOUND:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultTSpecNotFound());
        break;
    case BCME_ACM_NOTSUPPORTED:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultAcmNotSupported());
        break;
    case BCME_NOT_WME_ASSOCIATION:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultNotWmeAssociation());
        break;
    case BCME_SDIO_ERROR:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultSdioError());
        break;
    case BCME_DONGLE_DOWN:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultDongleDown());
        break;
    case BCME_VERSION:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultBadVersion());
        break;
    case BCME_TXFAIL:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultTxFail());
        break;
    case BCME_RXFAIL:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultRxFail());
        break;
    case BCME_NODEVICE:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultNoDevice());
        break;
    case BCME_NMODE_DISABLED:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultNModeDisabled());
        break;
    case BCME_NONRESIDENT:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultNonResident());
        break;
    case BCME_SCANREJECT:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultScanReject());
        break;
    case BCME_USAGE_ERROR:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultWlUsageError());
        break;
    case BCME_IOCTL_ERROR:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultWlIoctlError());
        break;
    case BCME_SERIAL_PORT_ERR:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultSerialPortError());
        break;
    case BCME_DISABLED:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultDisabledInThisBuild());
        break;
    case BCME_DECERR:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultDecryptError());
        break;
    case BCME_ENCERR:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultEncryptError());
        break;
    case BCME_MICERR:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultMicError());
        break;
    case BCME_REPLAY:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultReplay());
        break;
    case BCME_IE_NOTFOUND:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultIeNotFound());
        break;
    case BCME_DATA_NOTFOUND:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultDataNotFound());
        break;
    case BCME_ENOMEM:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultNoMemoryError());
        break;
    case BCME_EFAULT:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultFailToAccess());
        break;
    case BCME_EINVAL:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultInvalidMemory());
        break;
    case BCME_EIO:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultIOError());
        break;
    case BCME_ETIMEDOUT:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultTimeoutError());
        break;
    case BCME_ERESTARTSYS:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultRestartSystemError());
        break;
    case BCME_EREMOTEIO:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultRemoteIOError());
        break;
    case BCME_ENODEV:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultNoDeviceError());
        break;
    case BCME_FW_NOTRUN:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultFwFailedToRun());
        break;
    default:
        NN_ABORT_UNLESS_RESULT_SUCCESS(ResultCommandFailure());
        break;
    }
    NN_STATIC_ASSERT(BCME_LAST == BCME_FW_NOTRUN);
} // NOLINT(impl/function_size)

namespace driver {

void GetPeerMacAddress(uint8_t* pOutBuf, void* pBuf) NN_NOEXCEPT
{
    bcm_event_t* pBcmEvent = reinterpret_cast<bcm_event_t*>(pBuf);
    std::memcpy(pOutBuf, pBcmEvent->event.addr.octet, ETHER_ADDR_LEN);
}

size_t GetActionFrameDataSize(void* pBuf) NN_NOEXCEPT
{
    bcm_event_t* pBcmEvent = reinterpret_cast<bcm_event_t*>(pBuf);
    return ReverseEndian32(pBcmEvent->event.datalen);
}

size_t GetActionFrameDataSizeEx(void* pBuf) NN_NOEXCEPT
{
    bcm_event_t* pBcmEvent = reinterpret_cast<bcm_event_t*>(pBuf);
    return ReverseEndian32(pBcmEvent->event.datalen) - sizeof(wl_event_rx_frame_data_t);
}
}}}

