﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#define PRINT_ERROR_IF_FAILED(func) {               \
        int ret = (func);                           \
        if(ret != BWL_ERR_SUCCESS)               \
        {                                           \
            NN_LOG("<WLAN_TEST> !! FAILED [%s(%d) %s] err:%d(%s) \n",__FUNCTION__, __LINE__, #func , ret , bcmerrorstrtable[-ret]);  \
        }                                        \
        else{                                           \
            NN_LOG("<WLAN_TEST> PASS [%s(%d) %s]\n",__FUNCTION__, __LINE__, #func);  \
        }                                        \
        /*nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(1000));*/  \
    }

#define PRINT_ERROR_IF_SUCCESS(func) {               \
        int ret = (func);                           \
        if(ret == BWL_ERR_SUCCESS)               \
        {                                           \
            NN_LOG("<WLAN_TEST> !! Unexpected value [%s(%d) %d(%s) = %s]\n",__FUNCTION__, __LINE__, ret, bcmerrorstrtable[-ret], #func);  \
        }                                           \
        else{                                           \
            NN_LOG("<WLAN_TEST> PASS [%s(%d) %d(%s) = %s]\n",__FUNCTION__, __LINE__, ret, bcmerrorstrtable[-ret], #func);  \
        }                                        \
    } \

#define PRINT_ERROR()   NN_LOG("<WLAN_TEST> !! FAILED [%s(%d)]\n",__FUNCTION__, __LINE__)
#define DBG_PRINTF(format, args...)       NN_LOG("<WLAN_TEST>" format, ## args)



