﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>

#include "wlan_TestMacro.h"

namespace nn {
namespace wlan {

/* Network Operating Mode */
typedef enum wlan_test_parameter_type
{
    WLAN_PARAM_NONE                     = 0,  /* No parameter */
    WLAN_PARAM_ITF                      = 1,  /* Interface/handle */
    WLAN_PARAM_NUMBER                   = 2,    /* Number */
    WLAN_PARAM_PTR                      = 3,  /* Pointer */
    WLAN_PARAM_ETHER_ADDR_PTR           = 4,  /* Pointer to struct ether_addr */
    WLAN_PARAM_MACLIST_PTR              = 5,  /* Pointer to maclist */
    WLAN_PARAMETER_BWL_RATE_INFO_PTR    = 6, /* bwl_rate_info_t */
    WLAN_PARAMETER_NSC_SCAN_RESULTS_PTR = 7, /* nsc_scan_results_t */
    WLAN_PARAMETER_NSC_SCAN_DES_PTR     = 8, /* nsc_scandes_t */
    WLAN_PARAMETER_NSC_SSID_LIST_PTR    = 9, /* nsc_ssid_list_t */
    WLAN_PARAMETER_SSID_LIST_PTR        = 10, /* ssid_list_t */
    WLAN_PARAMETER_COUNTRY_PTR          = 11, /* wl_country_t */
    WLAN_PARAMETER_PM2_SLEEP_PTR        = 12, /* wl_pm2_sleep_ret_ext_t */
    WLAN_PARAMETER_RATESET_PTR          = 13, /* wl_rateset_args_t */
    WLAN_PARAMETER_SCB_PROBE_PTR        = 14, /* wl_scb_probe_t */

    WLAN_PARAM_END        =   15    /**/
} wlan_test_parameter_type_t;

#define WLAN_TEST_MAX_PARAMS    (12)  //NOLINT(preprocessor/const)

/* tricky - Use a prototype at 8 parameters all the time? */
typedef int32_t (*fn_12_t)(void*, uint64_t, uint64_t, uint64_t, uint64_t, uint64_t,
    uint64_t, uint64_t, uint64_t, uint64_t, uint64_t, uint64_t);

/* One function description:
 * - name
 * - pointer
 * - number of parameters
 * - parameter type array.
 */
typedef struct fn_desc {
    const char    name[96];    /*Unlikely to have a function name bigger with a 80 char
                             * per line limit.
                             */
    fn_12_t        fn;
    uint8_t        param_num;
    wlan_test_parameter_type_t params[WLAN_TEST_MAX_PARAMS];
} wlan_test_fn_descriptor_t;

class TestBwlApi
{
private:
    void Initialize();
    void Deinitialize();
    static int CbFunc_txcompletion(void *buf, int result);
    static int CbFunc_rxdata(void *buf);
    static int CbFunc_rxevent(void *event, void *buf);
    void RegisterCallback();
    uint64_t GetParam(wlan_test_parameter_type type, int index);
    int CheckFunc(int fn_idx, void* ifh);


public:
    TestBwlApi();
    ~TestBwlApi();

    /* Test API */
    /** Test intialization 1.3.6.7.1 */
    int InitTest(void);
    /** Test deinitialization 1.3.6.7.2 */
    int DeinitTest(void);
    /** Test interface parameter  1.3.6.7.3 */
    int InterfaceNullTest(void);
    /** Test BWL API with BWL inited 1.3.6.7.4 */
    int InitedApiTest(void);
    /** Test BWL API while deintialized 1.3.6.7.5 */
    int DeinitedApiTest(void);
    /** TODO Test function with structure parameters 1.3.6.7.6 */
    int InitedApiWithStructTest(void);
    /** TODO Test function with structure parameters while BWL
     * is not initialized intialization 1.3.6.7.7 */
    int DeinitedApiWithStructTest(void);
    /** FIXME Test ACSD APIs 1.3.6.7.8 */
    int Acsd(void);
    /** FIXME Test Wpa_Supplicant APIs. 1.3.6.7.9 */
    int WpaSupplicant(void);

    /** Run the BWL API invalid values testing */
    int Run(void);
};


}
}

