﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/nn_SdkLog.h>
#include <nn/gpio/gpio.h>


#if (defined(NN_BUILD_CONFIG_SPEC_NX))
static void InitializeGpioOutput(nn::gpio::GpioPadName pad, bool power)
{
    nn::gpio::GpioPadSession session;
    nn::gpio::Initialize();
    nn::gpio::OpenSession(&session, pad);
    nn::gpio::SetDirection(&session, nn::gpio::Direction_Output);
    nn::gpio::SetValue(&session, power ? nn::gpio::GpioValue_High : nn::gpio::GpioValue_Low);
    nn::gpio::CloseSession(&session);
    nn::gpio::Finalize();
}
#endif


void wlanGpioPowerEnable(bool power)
{
#if (defined(NN_BUILD_CONFIG_SPEC_NX))
    InitializeGpioOutput(nn::gpio::GpioPadName_WifiReset, power);
#endif
}

#if (defined(NN_BUILD_CONFIG_SPEC_NX))
void wlanGetGpioDirection(nn::gpio::GpioPadName pad, nn::gpio::Direction* pOutDirection )
{
    NN_SDK_ASSERT_NOT_NULL(pOutDirection);
    nn::gpio::GpioPadSession session;
    nn::gpio::Initialize();
    nn::gpio::OpenSession(&session, pad);
    *pOutDirection = nn::gpio::GetDirection(&session);
    nn::gpio::CloseSession(&session);
    nn::gpio::Finalize();
}
#endif

void wlanPrintOutBtGpioDirections()
{
#if (defined(NN_BUILD_CONFIG_SPEC_NX))
    nn::gpio::Direction btGpioDirections[4];
    for(int i=0; i<4; i++) btGpioDirections[i] = nn::gpio::Direction_Output;

    wlanGetGpioDirection(nn::gpio::GpioPadName_BtGpio2, &btGpioDirections[0] );
    wlanGetGpioDirection(nn::gpio::GpioPadName_BtGpio3, &btGpioDirections[1] );
    wlanGetGpioDirection(nn::gpio::GpioPadName_BtGpio4, &btGpioDirections[2] );
    wlanGetGpioDirection(nn::gpio::GpioPadName_BtGpio5, &btGpioDirections[3] );

    NN_SDK_LOG("BT GPIO2 DIRECTION : %s\n", (btGpioDirections[0] == nn::gpio::Direction_Input) ? "In" : "Out");
    NN_SDK_LOG("BT GPIO3 DIRECTION : %s\n", (btGpioDirections[1] == nn::gpio::Direction_Input) ? "In" : "Out");
    NN_SDK_LOG("BT GPIO4 DIRECTION : %s\n", (btGpioDirections[2] == nn::gpio::Direction_Input) ? "In" : "Out");
    NN_SDK_LOG("BT GPIO5 DIRECTION : %s\n", (btGpioDirections[3] == nn::gpio::Direction_Input) ? "In" : "Out");
#endif
}

// Configure given BtGpio pin.
// If you input true into "isOutput", a direction of the gpio pin will be set "out", otherwise, "in".
// If you input true into "power", a direction of the gpio pin will be set "out", otherwise, "in".
void wlanConfigureBtGpio(int btGpioNumber, bool isOutput, bool power)
{
#if (defined(NN_BUILD_CONFIG_SPEC_NX))
    nn::gpio::GpioPadSession session;
    nn::gpio::Initialize();
    switch( btGpioNumber )
    {
    case 2:
        nn::gpio::OpenSession(&session, nn::gpio::GpioPadName_BtGpio2);
        break;
    case 3:
        nn::gpio::OpenSession(&session, nn::gpio::GpioPadName_BtGpio3);
        break;
    case 4:
        nn::gpio::OpenSession(&session, nn::gpio::GpioPadName_BtGpio4);
        break;
    case 5:
        nn::gpio::OpenSession(&session, nn::gpio::GpioPadName_BtGpio5);
        break;
    default:
        NN_SDK_ASSERT(false, "Invalid btGpioNumber");
        break;
    }
    nn::gpio::SetDirection(&session, isOutput ? nn::gpio::Direction_Output : nn::gpio::Direction_Input);
    nn::gpio::SetValue(&session, power ? nn::gpio::GpioValue_High : nn::gpio::GpioValue_Low);
    nn::gpio::CloseSession(&session);
    nn::gpio::Finalize();
#endif
}

