﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sm/sm_UserApi.h>
#include <nn/nn_SdkLog.h>
#include <nn/pcv/pcv.h>
#include <nn/spl/spl_Api.h>

#include "../../Libraries/usb/detail/usb_Memory.h"
#include "../../Libraries/usb/detail/usb_InputNotifier.h"

#include "../../Libraries/usb/hs/usb_Hs.h"
#include "../../Libraries/usb/pm/usb_Pm.h"

#include "../../Libraries/usb/ds/usb_DsServiceManager.h"

#if (defined(NN_BUILD_CONFIG_SOC_TEGRA_K2) || defined(NN_BUILD_CONFIG_SOC_TEGRA_X1))
#include "../../Libraries/usb/detail/usb_PlatformNx.h"
static nn::usb::detail::UsbPlatformNx        g_Platform;
#else
#include "../../Libraries/usb/detail/usb_Platform.h"
static nn::usb::detail::UsbPlatform          g_Platform;
#endif

static nn::usb::detail::InputNotifier        g_InputNotifier;

#include "usb_PdServer.h"

static nn::usb::hs::Hs                       g_HostStack;
static nn::usb::pm::Pm                       g_PortManager;

static nn::usb::ds::DsServiceManager         g_DsService;

extern "C"
void nninitStartup()
{
}

extern "C"
void nndiagStartup()
{
}

#ifndef NN_BUILD_CONFIG_OS_WIN
// Override standard library allocators
extern "C" void* malloc(size_t size)
{
    return nn::usb::detail::UsbMemoryAlloc(size, "malloc()");
}

extern "C" void free(void* p)
{
    nn::usb::detail::UsbMemoryFree(p, "free()");
}

extern "C" void* calloc(size_t n, size_t size)
{
    return nn::usb::detail::UsbMemoryCalloc(n * size, "calloc()");
}

extern "C" void* realloc(void* p, size_t size)
{
    return nn::usb::detail::UsbMemoryRealloc(p, size, "realloc()");
}

extern "C" void* aligned_alloc(size_t alignment, size_t size)
{
    return nn::usb::detail::UsbMemoryAllocAligned(size, alignment, "aligned_alloc()");
}

extern "C" size_t malloc_usable_size(void* p)
{
    NN_UNUSED(p);
    NN_ABORT("malloc_usable_size is not implemented");
}

void* operator new(std::size_t size)                                      { return malloc(size); }
void* operator new(std::size_t size, const std::nothrow_t&) NN_NOEXCEPT   { return malloc(size); }
void  operator delete(void* ptr) NN_NOEXCEPT                              { free(ptr); }

void* operator new[](std::size_t size)                                    { return malloc(size); }
void* operator new[](std::size_t size, const std::nothrow_t&) NN_NOEXCEPT { return malloc(size); }
void  operator delete[](void* ptr) NN_NOEXCEPT                            { free(ptr); }
#endif

extern "C"
void nnMain()
{
    nn::Result result;

    NN_USB_LOG_INFO("nnMain() = %p\n", nnMain);

    nn::pcv::Initialize();

    NN_USB_ABORT_UPON_ERROR(nn::sm::Initialize());

    nn::usb::detail::UsbDiagInitialize();
    nn::usb::detail::UsbMemoryInit();

    nn::usb::InitializePdServer();

    g_Platform.Initialize();
    g_InputNotifier.Initialize();

    g_DsService.Initialize(&g_Platform);

    NN_USB_LOG_INFO("hostStack.Initialize()\n");
    if(g_HostStack.Initialize(&g_Platform).IsSuccess())
    {
        NN_USB_LOG_INFO("hostStack.BindComplex()\n");
        NN_USB_ABORT_UPON_ERROR(g_HostStack.BindComplex(nn::usb::ComplexId_Tegra21x));
    }

    NN_USB_LOG_INFO("portManager.Initialize()\n");
    g_PortManager.Initialize(&g_Platform, &g_InputNotifier);
    g_PortManager.MainLoop();

    // TORIAEZU:終了はしない
    NN_UNUSED(nn::usb::FinalizePdServer);

    NN_UNUSED(nn::usb::detail::UsbMemoryFinalize);
    NN_UNUSED(nn::usb::detail::UsbDiagFinalize);
}

