﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/svc/svc_Base.h>
#include <nn/ns/ns_DevelopApi.h>
#include "shell_Console.h"
#include "shell_CommandExecutorSet.h"

namespace nn { namespace shell {

    void InitializeProcessManager() NN_NOEXCEPT;
    void OnCreated(Bit64 processId, nn::svc::Handle handle) NN_NOEXCEPT;
    bool TerminateProcess(Bit64 processId) NN_NOEXCEPT;
    void PrintProcessList(const CommandExecuteContext* pContext) NN_NOEXCEPT;
    void InfoThreadList(const CommandExecuteContext* pContext) NN_NOEXCEPT;
    Result PrepareToLaunchProgram(ns::ProgramLaunchProperty* pOutProperty, const char* path, size_t length, const void* pArgument, size_t argumentSize) NN_NOEXCEPT;
    void FlushProgramArgument(ncm::ProgramId programId) NN_NOEXCEPT;


}}  // namespace nn::shell

