﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "shell_CommandExecutor.h"
#include "shell_ProcessManagementExecutor.h"

namespace nn { namespace shell {

class Console;

class CommandExecutorSet : public CommandExecutor
{
private:
    struct CommandExecuteInfo
    {
        const CommandDefinition*    pDefinition;
        CommandExecutor*            pExecutor;
        int                         commandIndexInExecutor;
    };

public:
    CommandExecutorSet() NN_NOEXCEPT;
    virtual ~CommandExecutorSet() NN_NOEXCEPT;

    int64_t Execute(Console* pConsole, int argc, const char* const* argv, const char* pCommandLine, size_t commandLineBytes, const char** pArgumentPositions) NN_NOEXCEPT;

    virtual void GetCommandDefinitions(const CommandDefinition** ppDefinitions, int *pCount) NN_NOEXCEPT;
    virtual int64_t Execute(const CommandExecuteContext* pContext, int commandIndex, int argc, const char* const* argv) NN_NOEXCEPT;
private:
    void Register(CommandExecutor* pExecutor) NN_NOEXCEPT;
    void Register(CommandExecutor* pExecutor, int commandIndexInExecutor, const CommandDefinition* pDefinition) NN_NOEXCEPT;
    const CommandExecuteInfo* GetExecuteInfo(const char* pCommandName) const NN_NOEXCEPT;
    void PrintCommandList(const CommandExecuteContext* pContext) const NN_NOEXCEPT;
    void PrintCommandCandidates(Console* pConsole, const char* pCommandName) const NN_NOEXCEPT;
    bool CommandExecuteInfoMatches(const CommandExecuteInfo* pExecuteInfo, const char* pCommandName) const NN_NOEXCEPT;

    static const int MaxCommandCount = 64;

    CommandExecuteInfo  m_ExecuteInfo[MaxCommandCount];
    int                 m_ExecuteInfoCount;

    ProcessManagementExecutor   m_ProcessManagementExecutor;
};

}}    // namespace nn { namespace shell {
