﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn { namespace shell {

class Console;

struct CommandDefinition
{
    const char*         pCommandName;       //! コマンド名
    int16_t             minArgCount;        //! 引数の数の最小（argv[0] を含まない）
    int16_t             maxArgCount;        //! 引数の数の最大（argv[0] を含まない）
    const char*         pShortCommandName;  //! 人間用の短いコマンド名
    const char*         pUsage;             //! コマンド引数の説明
};

struct CommandExecuteContext
{
    Console*        pConsole;
    const char*     pCommandLine;
    size_t          commandLineBytes;
    int             argumentCount;
    const char**    pArgumentPositions;
};

class CommandExecutor
{
public:
    CommandExecutor() NN_NOEXCEPT {}
    virtual ~CommandExecutor() NN_NOEXCEPT {}
    virtual int64_t Execute(const CommandExecuteContext* pContext, int commandIndex, int argc, const char* const* argv) NN_NOEXCEPT = 0;
    virtual void GetCommandDefinitions(const CommandDefinition** ppDefinitions, int *pCount) NN_NOEXCEPT = 0;
};

}}    // namespace nn { namespace shell {
