﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <new>

#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_SystemThreadDefinition.h>

#include <nn/account/account_ApiForSystemServices.h>
#include <nn/fs/fs_ApiPrivate.h>
#include <nn/init.h>
#include <nn/mii/mii_ApiServer.h>
#include <nn/os.h>
#include <nn/pl/srv/pl_HipcServer.h>
#include <nn/pm/pm_BootModeApi.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/time.h>

#include "sdb_PlatformServiceManagerMain.h"
#include "sdb_PlayDataManagerMain.h"

// 例外関連コードのリンク抑制のためのオーバーライド
// 参考：http://spdlybra.nintendo.co.jp/jira/browse/SIGLO-34162
void* operator new(std::size_t size) { return malloc(size); }
void* operator new(std::size_t size, const std::nothrow_t&) NN_NOEXCEPT { return malloc(size); }
void  operator delete(void* ptr) NN_NOEXCEPT { free(ptr); }

void* operator new[](std::size_t size) { return malloc(size); }
void* operator new[](std::size_t size, const std::nothrow_t&) NN_NOEXCEPT{ return malloc(size); }
void  operator delete[](void* ptr) NN_NOEXCEPT{ free(ptr); }

NN_ALIGNAS(4096) uint8_t  g_MallocBuffer[64 * 1024];

extern "C" void nninitStartup()
{
    nn::init::InitializeAllocator(g_MallocBuffer, sizeof(g_MallocBuffer));
}

extern "C" void nnMain()
{
    nn::os::SetThreadNamePointer(nn::os::GetCurrentThread(), NN_SYSTEM_THREAD_NAME(sdb, MainThread));

    nn::fs::InitializeWithMultiSessionForSystem();

    nn::account::InitializeForSystemService();
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::time::Initialize());

    if( nn::pm::GetBootMode() != nn::pm::BootMode_Maintenance )
    {
        nn::sdb::RegisterPlayDataManager();
        nn::sdb::StartPlayDataManagerMain();

        nn::mii::RegisterServer();
        nn::mii::StartServer();
    }

    nn::pl::srv::CreateServer();
    nn::pl::srv::StartServer();
    nn::pl::srv::LoopAuto();

    // メモリ消費量抑制のため Mainスレッドで pl の LoopAuto を回しているので、以下はコメントアウト。
    // nn::sdb::RegisterPlatformServiceManager();
    // nn::sdb::StartPlatformServiceManagerMain();

    // nn::os::Event e(nn::os::EventClearMode_ManualClear);
    // e.Wait();
}
