﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstring>
#include <nn/htcs.h>

#include "scs_CommandProcessor.h"

namespace
{
    const size_t CommandReceiveBufferSize = 64 * 1024;
}

namespace nn { namespace scs {

    class ShellServer {
    public:
        void Initialize(const char* portName, void* pStack, size_t stackSize, CommandProcessor* pCommandProcessor);
        void Start();

    private:
        static void ThreadFunc(void* arg);
        void DoShellServer();

        htcs::HtcsPortName m_HtcsPortName;
        os::ThreadType m_Thread;
        Bit8 m_Buffer[CommandReceiveBufferSize];
        CommandProcessor* m_pCommandProcessor;
    };

}}  // namespace nn::scs
