﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ProgramId.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/arp/arp_Types.h>
#include <nn/os.h>
#include <nn/ns/ns_DevelopApi.h>

namespace nn { namespace scs {

    typedef void (* ProcessEventHandler)(int64_t commandId, int socket, os::ProcessId processId);

    void InitializeShell();

    Result PrepareToLaunchProgram(
            ns::ProgramLaunchProperty*  pOutProperty,
            const char*                 pPath,
            size_t                      pathSize,
            const void*                 pArgument,
            size_t                      argumentSize ) NN_NOEXCEPT;

    Result PrepareToLaunchProgram(
            ncm::ProgramId  programId,
            const void*     pArgument,
            size_t          argumentSize ) NN_NOEXCEPT;

    void FlushProgramArgument(ncm::ProgramId programId) NN_NOEXCEPT;

    os::Mutex* GetProcessManagementMutex();

    bool CanRegisterProcessEventHandler();

    void RegisterCommonProcessEventHandler(ProcessEventHandler pStartHandler, ProcessEventHandler pExitHandler, ProcessEventHandler pJitDebugHandler);
    bool RegisterProcessEventHandler(
            os::ProcessId       processId,
            int64_t             commandId,
            int                 socket,
            bool                isLaunchedByCs,
            bool                isDebugEnabled );

    Result TerminateProcessAny(int64_t* pOutRegisteredCommandId);

    void RaiseLaunchedEventAny(int64_t commandId, int socket, ProcessEventHandler pLaunchHandler);
    bool RegisterSocket(int socket);
    void UnregisterSocket(int socket);
    Result SubscribeProcessEvent(int socket, bool isRegister, int64_t commandId);

}}  // namespace nn::scs
