﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_HipcServer.h>

namespace nn { namespace scs {

    enum Port
    {
        Port_HtcTenv,
        Port_Count
    };

    template<int Count> constexpr int Accumulate(int const (& array)[Count], int offset = 0)
    {
        return ((offset < Count) ? array[offset] + Accumulate(array, offset + 1): 0);
    }

    constexpr int SessionCount[Port_Count] =
    {
        6, // Application, Menu, Applet * 2, Overlay + margin
    };
    constexpr int MaxAllSessionCount = Accumulate(SessionCount);

    struct MyServerOption
    {
        static const int    SubDomainCountMax         = 6;
        static const int    ObjectInSubDomainCountMax = 16;
    };

    class MyServerManager
        : public sf::HipcSimpleAllInOneServerManager<MaxAllSessionCount, Port_Count, MyServerOption>
    {
    };

    MyServerManager* GetServerManager();
    void StartServer();

}}  // namespace nn::scs

