﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_SystemThreadDefinition.h>
#include <nn/os/os_Thread.h>
#include <nn/sf/sf_HipcServer.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/sf/sf_ObjectFactory.h>

#include "scs_Infrastructure.h"

namespace nn { namespace scs {

    namespace
    {
        MyServerManager g_ServerManager;

        const size_t ThreadStackSize = 0x4000;

        nn::os::ThreadType              g_Thread;
        NN_OS_ALIGNAS_THREAD_STACK char g_ThreadStack[ThreadStackSize];

        void ThreadFunc(void* arg) NN_NOEXCEPT
        {
            NN_UNUSED(arg);
            g_ServerManager.LoopAuto();
        }
    }

    MyServerManager* GetServerManager()
    {
        return &g_ServerManager;
    }

    void StartServer()
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(
            os::CreateThread(
                &g_Thread,
                &ThreadFunc,
                nullptr,
                g_ThreadStack,
                ThreadStackSize,
                NN_SYSTEM_THREAD_PRIORITY(scs, TenvServer) ));

        os::SetThreadNamePointer(&g_Thread, NN_SYSTEM_THREAD_NAME(scs, TenvServer));
        os::StartThread(&g_Thread);
    }

}}  // namespace nn::scs

