﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>


#define NN_REG_GET_SHIFT(r) (0 ? r)
#define NN_REG_GET_MASK(r)  ((~0u >> (32 - ((1 ? r) - (0 ? r) + 1))) << (NN_REG_GET_SHIFT(r)))


#define NN_REG_MAKE_BITS_BY_NAME(bitsName, valueName) \
    ( static_cast<nn::Bit32>(bitsName ## _ ## valueName) << NN_REG_GET_SHIFT(bitsName ## _RANGE) )

#define NN_REG_MAKE_BITS_BY_VALUE(bitsName, value) \
    ( static_cast<nn::Bit32>(value) << NN_REG_GET_SHIFT(bitsName ## _RANGE) )

#define NN_REG_EXTRACT_BITS(regVal, bitsName) \
    ( (regVal & NN_REG_GET_MASK(bitsName ## _RANGE)) >> NN_REG_GET_SHIFT(bitsName ## _RANGE) )

#define NN_REG_SET_BITS_BY_NAME(var, bitsName, valueName) \
    ((var & ~NN_REG_GET_MASK(bitsName ## _RANGE)) | (static_cast<nn::Bit32>(bitsName ## _ ## valueName) << NN_REG_GET_SHIFT(bitsName ## _RANGE)))

#define NN_REG_SET_BITS_BY_VALUE(var, bitsName, value) \
    ((var & ~NN_REG_GET_MASK(bitsName ## _RANGE)) | ( static_cast<nn::Bit32>(value) << NN_REG_GET_SHIFT(bitsName ## _RANGE) ))

#define NN_REG_TRANSPLANT_BITS(baseValue, bitsName, donorValue) \
    NN_REG_SET_BITS_BY_VALUE(baseValue, bitsName, NN_REG_EXTRACT_BITS(donorValue, bitsName))




#define NN_REG_UPDATE_BY_NAME(domainName, registerName, fieldName, valueName) \
    nn::reg::ReadSetWrite( \
        (NN_BLSM_REG_ ## domainName) + (registerName), \
        NN_REG_GET_SHIFT(registerName ## _ ## fieldName ## _RANGE), \
        ((1 ? registerName ## _ ## fieldName ## _RANGE) - NN_REG_GET_SHIFT(registerName ## _ ## fieldName ## _RANGE) + 1), \
        (registerName ## _ ## fieldName ## _ ## valueName) )

#define NN_REG_UPDATE_BY_VALUE(domainName, registerName, fieldName, value) \
    nn::reg::ReadSetWrite( \
        (NN_BLSM_REG_ ## domainName) + (registerName), \
        NN_REG_GET_SHIFT(registerName ## _ ## fieldName ## _RANGE), \
        ((1 ? registerName ## _ ## fieldName ## _RANGE) - NN_REG_GET_SHIFT(registerName ## _ ## fieldName ## _RANGE) + 1), \
        (value) )



#define NN_REG_MAKE_BITS_1(registerName, \
            field1Type, field1Name, field1Value ) \
    ( NN_REG_MAKE_BITS_BY_ ## field1Type (registerName ## _ ## field1Name, field1Value) )

#define NN_REG_MAKE_BITS_2(registerName, \
            field1Type, field1Name, field1Value, \
            field2Type, field2Name, field2Value ) \
    ( NN_REG_MAKE_BITS_BY_ ## field1Type (registerName ## _ ## field1Name, field1Value) \
    | NN_REG_MAKE_BITS_BY_ ## field2Type (registerName ## _ ## field2Name, field2Value) )

#define NN_REG_MAKE_BITS_3(registerName, \
            field1Type, field1Name, field1Value, \
            field2Type, field2Name, field2Value, \
            field3Type, field3Name, field3Value ) \
    ( NN_REG_MAKE_BITS_BY_ ## field1Type (registerName ## _ ## field1Name, field1Value) \
    | NN_REG_MAKE_BITS_BY_ ## field2Type (registerName ## _ ## field2Name, field2Value) \
    | NN_REG_MAKE_BITS_BY_ ## field3Type (registerName ## _ ## field3Name, field3Value) )

#define NN_REG_MAKE_BITS_4(registerName, \
            field1Type, field1Name, field1Value, \
            field2Type, field2Name, field2Value, \
            field3Type, field3Name, field3Value, \
            field4Type, field4Name, field4Value ) \
    ( NN_REG_MAKE_BITS_BY_ ## field1Type (registerName ## _ ## field1Name, field1Value) \
    | NN_REG_MAKE_BITS_BY_ ## field2Type (registerName ## _ ## field2Name, field2Value) \
    | NN_REG_MAKE_BITS_BY_ ## field3Type (registerName ## _ ## field3Name, field3Value) \
    | NN_REG_MAKE_BITS_BY_ ## field4Type (registerName ## _ ## field4Name, field4Value) )


#define NN_REG_WRITE(domainName, registerName, value) \
    nn::reg::Write( (NN_BLSM_REG_ ## domainName) + (registerName ##  _0), value )

#define NN_REG_WRITE_1(domainName, registerName, \
            field1Type, field1Name, field1Value ) \
    nn::reg::Write( \
        (NN_BLSM_REG_ ## domainName) + (registerName ##  _0), \
        NN_REG_MAKE_BITS_BY_ ## field1Type (registerName ## _0_ ## field1Name, field1Value) )

#define NN_REG_WRITE_2(domainName, registerName, \
            field1Type, field1Name, field1Value, \
            field2Type, field2Name, field2Value ) \
    nn::reg::Write( (NN_BLSM_REG_ ## domainName) + (registerName ## _0), \
        NN_REG_MAKE_BITS_2(registerName ## _0, \
            field1Type, field1Name, field1Value, \
            field2Type, field2Name, field2Value ))

#define NN_REG_WRITE_3(domainName, registerName, \
            field1Type, field1Name, field1Value, \
            field2Type, field2Name, field2Value, \
            field3Type, field3Name, field3Value ) \
    nn::reg::Write( (NN_BLSM_REG_ ## domainName) + (registerName ## _0), \
        NN_REG_MAKE_BITS_3(registerName ## _0, \
            field1Type, field1Name, field1Value, \
            field2Type, field2Name, field2Value, \
            field3Type, field3Name, field3Value ))

#define NN_REG_WRITE_4(domainName, registerName, \
            field1Type, field1Name, field1Value, \
            field2Type, field2Name, field2Value, \
            field3Type, field3Name, field3Value, \
            field4Type, field4Name, field4Value ) \
    nn::reg::Write( (NN_BLSM_REG_ ## domainName) + (registerName ## _0), \
        NN_REG_MAKE_BITS_4(registerName ## _0, \
            field1Type, field1Name, field1Value, \
            field2Type, field2Name, field2Value, \
            field3Type, field3Name, field3Value, \
            field4Type, field4Name, field4Value ))

#define NN_REG_WRITE_5(domainName, registerName, \
            field1Type, field1Name, field1Value, \
            field2Type, field2Name, field2Value, \
            field3Type, field3Name, field3Value, \
            field4Type, field4Name, field4Value, \
            field5Type, field5Name, field5Value ) \
    nn::reg::Write( (NN_BLSM_REG_ ## domainName) + (registerName ## _0), \
        ( NN_REG_MAKE_BITS_2(registerName ## _0,    \
            field1Type, field1Name, field1Value,    \
            field2Type, field2Name, field2Value )   \
        | NN_REG_MAKE_BITS_3(registerName ## _0,    \
            field3Type, field3Name, field3Value,    \
            field4Type, field4Name, field4Value,    \
            field5Type, field5Name, field5Value )))

#define NN_REG_WRITE_6(domainName, registerName, \
            field1Type, field1Name, field1Value, \
            field2Type, field2Name, field2Value, \
            field3Type, field3Name, field3Value, \
            field4Type, field4Name, field4Value, \
            field5Type, field5Name, field5Value, \
            field6Type, field6Name, field6Value ) \
    nn::reg::Write( (NN_BLSM_REG_ ## domainName) + (registerName ## _0), \
        ( NN_REG_MAKE_BITS_3(registerName ## _0,    \
            field1Type, field1Name, field1Value,    \
            field2Type, field2Name, field2Value,    \
            field3Type, field3Name, field3Value )   \
        | NN_REG_MAKE_BITS_3(registerName ## _0,    \
            field4Type, field4Name, field4Value,    \
            field5Type, field5Name, field5Value,    \
            field6Type, field6Name, field6Value )))


#define NN_REG_READ(domainName, registerName) \
    nn::reg::Read( (NN_BLSM_REG_ ## domainName) + (registerName ## _0) )

#define NN_REG_READ_1(domainName, registerName, fieldName) \
    NN_REG_EXTRACT_BITS( \
        reg::Read( (NN_BLSM_REG_ ## domainName) + (registerName ## _0) ), \
        registerName ## _0_ ## fieldName )


namespace nn { namespace reg {

    inline void Write(uintptr_t address, Bit32 value) __attribute__((always_inline));
    inline void Write(uintptr_t address, Bit32 value)
    {
        *reinterpret_cast<volatile Bit32*>(address) = value;
    }
    inline void Write8(uintptr_t address, Bit8 value) __attribute__((always_inline));
    inline void Write8(uintptr_t address, Bit8 value)
    {
        *reinterpret_cast<volatile Bit8*>(address) = value;
    }

    inline Bit32 Read(uintptr_t address) __attribute__((always_inline));
    inline Bit32 Read(uintptr_t address)
    {
        return *reinterpret_cast<volatile Bit32*>(address);
    }

    inline void ReadSetWrite(uintptr_t address, int pos, int width, Bit32 v) __attribute__((always_inline));
    inline void ReadSetWrite(uintptr_t address, int pos, int width, Bit32 v)
    {
        auto r = Read(address);
        Bit32 mask = (~0u >> (32 - width)) << pos;
        r = (r & ~mask) | ((v << pos) & mask);
        Write(address, r);
    }


}}
