﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/svc/svc_Base.h>
#include <nn/svc/svc_Tcb.h>
#include <nn/nn_Abort.h>

namespace nn { namespace ro {

    class AutoCloseHandle
    {
    public:
        explicit AutoCloseHandle(svc::Handle handle) NN_NOEXCEPT
            : m_Handle(handle)
        {
        }
        ~AutoCloseHandle() NN_NOEXCEPT
        {
            if( m_Handle != svc::INVALID_HANDLE_VALUE )
            {
                svc::CloseHandle(m_Handle);
            }
        }
        void Cancel() NN_NOEXCEPT
        {
            m_Handle = svc::INVALID_HANDLE_VALUE;
        }

    private:
        svc::Handle m_Handle;
    };

    class AutoCloseMap
    {
    public:
        AutoCloseMap(uintptr_t mapAddress, svc::Handle handle, uint64_t begin, uint64_t size) NN_NOEXCEPT
            : m_MapAddress(mapAddress)
            , m_Handle(handle)
            , m_Begin(begin)
            , m_Size(size)
        {
            m_Result = svc::MapProcessMemory(m_MapAddress, m_Handle, m_Begin, m_Size);
        }
        ~AutoCloseMap() NN_NOEXCEPT
        {
            if( m_Handle != svc::INVALID_HANDLE_VALUE && m_Result.IsSuccess() )
            {
                Result result = svc::UnmapProcessMemory(m_MapAddress, m_Handle, m_Begin, m_Size);
                NN_ABORT_UNLESS_RESULT_SUCCESS(result);
            }
        }
        Result GetResult() const NN_NOEXCEPT
        {
            return m_Result;
        }
        bool IsFailure() const NN_NOEXCEPT
        {
            return m_Result.IsFailure();
        }
        void Cancel() NN_NOEXCEPT
        {
            m_Handle = svc::INVALID_HANDLE_VALUE;
        }

    private:
        Result      m_Result;
        uintptr_t   m_MapAddress;
        svc::Handle m_Handle;
        uint64_t    m_Begin;
        uint64_t    m_Size;
    };

}}  // namespace nn::ro
