﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn { namespace profiler {

    enum ThreadPriority : int
    {
        ThreadPriority_Main         = 20, // Core 3, priority from DESC, doesn't change

        ThreadPriority_Core         =  0, // ProfilerPrimaryCore; inprocess priority was 2
        ThreadPriority_PccomRecv    = -2, // ProfilerPrimaryCore; inprocess priority was 0
        ThreadPriority_SvcWatch     =  0, // ProfilerPrimaryCore
        ThreadPriority_PccomSend    = -1, // ProfilerPrimaryCore; inprocess priority was 0
        ThreadPriority_PccomWait    = -1, // ProfilerPrimaryCore; inprocess priority was 0
        ThreadPriority_Vsync        = -1, // ProfilerPrimaryCore; inprocess priority was 0

        // Cores 0 - 3
        // TODO: Core 3 Sampler may need a much, much higher priority
        ThreadPriority_Sampler      = -2, // TargetWatch, Core yields to the samplers; inprocess priority was 0
        ThreadPriority_SamplerGuard = -1, // To prevent for application threads to run when sampler threads are blocked
    };

}} // nn::profiler
