﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_ThreadCommon.h>
#include <nn/osdbg/osdbg_Thread.h>
#include <nn/svc/svc_DmntType.h>

namespace nn { namespace profiler {

struct ThreadListItem
{
    uint64_t id;

    void* threadType;
    //nn::osdbg::ThreadInfo threadInfo;
    nn::svc::DebugInfoCreateThread threadInfo;

    inline nn::svc::DebugInfoCreateThread* GetDebugInfo()
    {
        //return &threadInfo._debugInfoCreateThread;
        return &this->threadInfo;
    }

    uintptr_t stackBase;
    size_t    stackSize;

    char threadName[nn::os::ThreadNameLengthMax];
    int priority;
    int coreMask;
    unsigned idealCore;

    NN_IMPLICIT ThreadListItem(::nn::Bit64 thread);
    ~ThreadListItem();

    // no default ctor, copy ctor, move ctor, or assignment
    ThreadListItem() = delete;
    ThreadListItem(const ThreadListItem&) = delete;
    ThreadListItem(ThreadListItem&&) = delete;
    ThreadListItem& operator=(const ThreadListItem&) = delete;
    ThreadListItem& operator=(ThreadListItem&&) = delete;

    void SetThreadName(const char* name);
};


}} // nn::profiler
