﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

NN_PRAGMA_PUSH_WARNINGS
#pragma GCC diagnostic ignored "-Wsign-conversion"
#include <nn/os/os_Thread.h>
#include <nn/svc/svc_Base.h>
NN_PRAGMA_POP_WARNINGS

#include "profiler_ThreadListItem.h"
#include "profiler_TargetApplication.h"

namespace nn { namespace profiler {

NN_IMPLICIT ThreadListItem::ThreadListItem(::nn::Bit64 thread) :
    stackBase(0),
    stackSize(0),
    priority(0),
    coreMask(0),
    idealCore(0)
{
    id = thread;

    // Thread info is filled in via TargetApplication.cpp
    memset(&threadInfo, 0, sizeof(threadInfo));

    memset(threadName, 0, nn::os::ThreadNameLengthMax);
}


ThreadListItem::~ThreadListItem()
{
}


void ThreadListItem::SetThreadName(const char* name)
{
    if (name != nullptr)
    {
        strncpy(threadName, name, nn::os::ThreadNameLengthMax);
        threadName[nn::os::ThreadNameLengthMax - 1] = '\0';
    }
}


}} // nn::profiler
