﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_ThreadTypes.h>

namespace nn { namespace profiler {

struct SettingsFromThePcGui;
struct WorkArea;


nn::Result InitializeSamplingThreads();
nn::Result FinalizeSamplingThreads();
bool AreSamplingThreadsInitialized();

void PrepareInstrumentationBuffer(SettingsFromThePcGui* settings);
void CloseInstrumentationBuffer();

void StartProfilingSamplingThreads(SettingsFromThePcGui* settings);
void StopProfilingSamplingThreads();

void SamplingTriggerSample(uint32_t core, nn::os::ThreadId thread);
void SamplingTriggerStop(uint32_t core);

void WaitCoresClosed();
void WaitProfilingStarted();
void WaitSamples();

void DumpSamplingThreadInfo();

void SamplingThread_RecordImmediate(WorkArea* ws, uint32_t core, nn::os::ThreadId thread);

} // profiler
} // nn
